#include <iostream>
#include <vector>
#include <algorithm>
#include <limits.h>
#include <map>
using namespace std;

struct jr
{
    int x;
    int h = -1;
};

struct najblizi {
    long int visina;  // key u rasporedjeni
    long int x;         // jarbol.x
    long int h;         // jarbol.h
    long int rastojanje;      // rastojanje po x osi od mojeX
};


najblizi nadjinajblizegsvojisledeci
    (
    const map<long, map<long, long>>& rasporedjeni,

     map<long, map<long, long>>::const_iterator startIt,

    long mojeX
    )

{
    najblizi result{ -1, -1, -1, INT_MAX };

    if (startIt == rasporedjeni.end())
        return result;


    // medju svojima ako ih je > 1
    if (startIt->second.size() > 1)
    {
        long int duzL = INT_MAX, duzD = INT_MAX;

        auto it2 = lower_bound(startIt->second.begin(), startIt->second.end(), mojeX,
            [](const pair<long, long>& a, const long& b) { return a.first < b; });

        // nadji prvog levo
        if (it2 != startIt->second.begin())
        {
            auto levi = prev(it2);
            duzL = mojeX - levi->first;
        }

        // nadji prvog desno
        auto desni = next(it2);
        if (desni != startIt->second.end())
        {
            duzD = desni->first - mojeX;
        }
        long mini = min(duzL, duzD);
        result = {startIt->first, mojeX, startIt->first, mini};
    }


// gledaj sve vece visine
    auto it = next(startIt);
    for (; it != rasporedjeni.end(); ++it)
    {
        const auto& tackeIsteVisine = it->second;

// nadjemo najblizi x u tackeIsteVisine
        auto ivIt = tackeIsteVisine.lower_bound(mojeX);


        if (ivIt != tackeIsteVisine.end())
        {
            long int diff = abs(ivIt->first - mojeX);

            if (diff < result.rastojanje)
            {
                result = { it->first, ivIt->first, ivIt->second, diff };
            }
        }


        if (ivIt != tackeIsteVisine.begin())
        {
            auto prevIt = prev(ivIt);
            long int diff = abs(prevIt->first - mojeX);
            if (diff < result.rastojanje)
            {
                result = { it->first, prevIt->first, prevIt->second, diff };
            }
        }
    }

    return result;
}


int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    int n;
    cin >> n;
    vector<struct jr> jarbol(n);

    for (int i = 0; i < n; i++)
        cin >> jarbol[i].x;

    // uneli smo x
    // nije sortiran
    // mapa ce da obezbedi da budu sortirani

    map<long int, map<long int, long int>> rasporedjeni;


    //int maxy = -1;// maksimum, da vidimo da ne racunamo za njega i one jednake visine

    for (long int i = 0; i < n; i++)
    {
        cin >> jarbol[i].h;

        if (rasporedjeni.find(jarbol[i].h) != rasporedjeni.end())
        {
            rasporedjeni[jarbol[i].h].insert({ jarbol[i].x, jarbol[i].h });
        }
        else
        {
            map<long int, long int> temp;

            temp.insert({ jarbol[i].x, jarbol[i].h });

            rasporedjeni.insert({ jarbol[i].h, temp });
        }


    }

    for (long int i = 0; i < n; i++)
    {
        long int duzL = INT_MAX, duzD = INT_MAX;

        // cvorovi moje visine
        auto it = rasporedjeni.find(jarbol[i].h);

        // cvorovi vece visine
        auto nextIt = next(it);

        if (nextIt == rasporedjeni.end())
        {
            // ako nema vecih, trazi samo medju svojom visinom
            if (it->second.size() > 1)
            {
                auto it2 = lower_bound(it->second.begin(), it->second.end(), jarbol[i].x,
                    [](const pair<long int, long int>& a, const long int& b) { return a.first < b; });

                // nadji prvog levo
                if (it2 != it->second.begin())
                {
                    auto levi = prev(it2);
                    duzL = jarbol[i].x - levi->first;
                }

                // nadji prvog desno
                auto desni = next(it2);

                if (desni != it->second.end())
                {
                    duzD = desni->first - jarbol[i].x;
                }

                int mini = min(duzL, duzD);
                cout << mini << '\n';
            }
            else
            {
                // ako je samo jedan od najvecih
                cout << "-1" << '\n';
            }
            continue;
}

        // ako ima vecih, trazi medju vecom visinom

        // razlika visina za tacke kao sto je x

        najblizi res = nadjinajblizegsvojisledeci(rasporedjeni, it, jarbol[i].x);
        long int deltaH = res.h - jarbol[i].h;
        res.rastojanje -= deltaH;
        cout << res.rastojanje << '\n';

    }


    return 0;
}